/*
 Abstract Syntax Tree (AST) Printer Example
 Design Tool Studio
 Taught by Patrick Hebron @ NYU ITP
 */

#include "Ast.h"
#include "Visitor.h"

int main(int argc, const char * argv[])
{
	AstBaseRef tFormula =
	AstBinaryAdd::create( AstBinaryAdd::create( AstNumber::create( 4.0 ), AstNumber::create( 3.0 ) ), AstNumber::create( 2.0 ) );
	
	std::cout << "Version 1:" << std::endl;
	
	tFormula->print();
	std::cout << std::endl << std::endl;
	
	std::cout << "Version 2:" << std::endl;
	
	Visitor tPrintVisitor;
	tFormula->accept( tPrintVisitor );
	
    return 0;
}
