/*
 Abstract Syntax Tree (AST) Printer Example
 Design Tool Studio
 Taught by Patrick Hebron @ NYU ITP
 */

#include "Visitor.h"

Visitor::Visitor() : mTabs( 0 )
{
	/* no-op */
}

void Visitor::visit(AstNumber* entity)
{
	std::cout << std::string( mTabs, '\t' ) << entity->getValue() << std::endl;
}

void Visitor::visit(AstBinaryAdd* entity)
{
	std::cout << std::string( mTabs++, '\t' ) << '(' << std::endl;
	entity->getLhs()->accept( *this );
	std::cout << std::string( mTabs, '\t' ) << '+' << std::endl;
	entity->getRhs()->accept( *this );
	std::cout << std::string( --mTabs, '\t' ) << ')' << std::endl;
}
