/*
 Abstract Syntax Tree (AST) Printer Example
 Design Tool Studio
 Taught by Patrick Hebron @ NYU ITP
 */

#include "Ast.h"
#include "Visitor.h"

AstBase::AstBase()
{
	/* no-op */
}

AstBase::~AstBase()
{
	/* no-op */
}

AstNumber::AstNumber(float value) : mValue( value )
{
	/* no-op */
}

const float& AstNumber::getValue() const
{
	return mValue;
}

void AstNumber::print() const
{
	std::cout << mValue;
}

void AstNumber::accept(Visitor& visitor)
{
	visitor.visit( this );
}

AstBinaryAdd::AstBinaryAdd(AstBaseRef lhs, AstBaseRef rhs) : mLhs( lhs ), mRhs( rhs )
{
	/* no-op */
}

AstBaseRef AstBinaryAdd::getLhs() const
{
	return mLhs;
}

AstBaseRef AstBinaryAdd::getRhs() const
{
	return mRhs;
}

void AstBinaryAdd::print() const
{
	std::cout << '(';
	mLhs->print();
	std::cout << '+';
	mRhs->print();
	std::cout << ')';
}

void AstBinaryAdd::accept(Visitor& visitor)
{
	visitor.visit( this );
}
